﻿//////////////////////////////////////////////
// Image.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkImages
{
	class ImageView ;
}

/// Includes ---------------------------------

// nkImages
#include "../Dll/DllDefines.h"

#include "ImageBase.h"

// nkMemory
#include <NilkinsMemory/Containers/Buffer.h>

/// Class ------------------------------------

namespace nkImages
{
	class DLL_IMAGES_EXPORT Image final : public ImageBase
	{
		public :

			// Constructor, destructor
			Image () noexcept ;
			Image (nkMemory::Buffer&& data) noexcept ;
			Image (nkMemory::Buffer&& data, unsigned int width, unsigned int height, unsigned int depth, PIXEL_FORMAT format, unsigned int pixelOrBlockByteSize = 0, unsigned int rowByteSize = 0, unsigned int sliceByteSize = 0) noexcept ;
			Image (nkMemory::Buffer&& data, unsigned int width, unsigned int height, unsigned int depth, unsigned int arraySize, unsigned int mips, PIXEL_FORMAT format, unsigned int pixelOrBlockByteSize = 0) noexcept ;
			Image (nkMemory::Buffer&& data, nkMemory::BufferCast<ImageDescriptor>&& images, PIXEL_FORMAT format, unsigned int pixelOrBlockByteSize, bool alphaPremultiplied = false, bool cubeMap = false) noexcept ;
			Image (const Image& other) noexcept ;
			Image (Image&& other) noexcept ;
			Image (const ImageView& view) noexcept ;
			virtual ~Image () ;

			// Data access
			virtual unsigned char* getDataPtr () const override ;
			virtual unsigned long long getDataByteSize () const override ;
			virtual nkMemory::BufferView<> getDataBuffer () const override ;
			virtual bool isView () const override ;
			const nkMemory::Buffer& getData () const ;

			// Operators
			Image& operator= (const Image& other) noexcept ;
			Image& operator= (Image&& other) noexcept ;

		private :

			// Attributes
			// View over the data, provided from outside
			nkMemory::Buffer _data ;
	} ;
}